/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.browser;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpConfigGroup;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import java.awt.Point;

public class BrowserApp
extends JdmBrowser {
    NavigationFolder root;
    NavigationDestination wip = new NavigationDestination("ibm.nways.jdm.WorkInProgressDestination");
    NavigationDestination nothing = new NavigationDestination("ibm.nways.jdm.NilDestination");
    GenModel model;
    SnmpContextModel snmpmodel;
    String ipAddress = "unknown address";

    protected NavigationPoint getNavTreeRoot() {
        this.displayMsg("Accessing server for device characteristics ...");
        try {
            this.model = (GenModel)this.getModel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.snmpmodel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
            ModelInfo modelInfo = this.snmpmodel.getConfig();
            this.ipAddress = modelInfo.get("Config.Address").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("snmpmodel = " + this.snmpmodel);
        this.displayMsg("Server contacted.");
        this.root = new NavigationFolder("Network Device at " + this.ipAddress, this.wip);
        return this.root;
    }

    public void getRestOfNavTree() {
        NavigationBrowser navigationBrowser = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put("TREE", navigationBrowser);
        this.displayMsg("Adding SNMP configuration panel");
        SnmpConfigGroup snmpConfigGroup = new SnmpConfigGroup(this.snmpmodel);
        snmpConfigGroup.setIsInitiallyExpanded(false);
        navigationBrowser.addEventListener(snmpConfigGroup);
        this.root.add(snmpConfigGroup);
        this.displayMsg("Adding MIB browser");
        try {
            Browser browser = new Browser("MIB Browser", this, this.snmpmodel);
            navigationBrowser.addEventListener(browser);
            this.root.add(browser.getRootFolder());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.displayMsg("Initialization complete.");
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicImage graphicImage = new GraphicImage(this.imageFrom(this, "box.gif"), new Point(0, 0), 1);
        GraphicContainer graphicContainer = new GraphicContainer();
        graphicContainer.add(graphicImage);
        GraphicPanel graphicPanel = new GraphicPanel(this, graphicContainer);
        graphicPanel.setVisible(false);
        return graphicPanel;
    }

    public String getModelTypeName() {
        return "ibm.nways.jdm.browser.Browser";
    }
}

